
#ifndef _1_CRYS_ATP_TST_HMACFLOW_Acceptance_h_H
#define _1_CRYS_ATP_TST_HMACFLOW_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_FLOW.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 14 10:18:14 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_HMACFLOW_Acceptance.h#1:incl:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
typedef struct TST_HMACFLOW_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];

	/* input interrupt id */
	DxUint32_t                  inputInterruptId;

	/* output interrupt id */
	DxUint32_t                  outputInterruptId;


	/* if the data in the buffers are in words and not bytes */ 
	DxUint32_t                  wordsBuffersOrderFlag;

	/* number of input buffers */
	DxUint16_t                  inputBuffersArraySize;

	/* flag if  endian order of the input buffers is big */
	DxUint32_t                  inputBigEndianOrderFlag;

	/* number of input buffers */
	DxUint16_t                  outputBuffersArraySize;


	/* flag if  endian order of the output buffers is big */
	DxUint32_t                  outputBigEndianOrderFlag;

	DxUint8_t 			        TST_Expected_output_data[TST_FLOW_DATA_VEC_SIZE_IN_BYTS];
	
	DxUint8_t                   TST_Expected_cyclicOperation_data[TST_FLOW_DATA_VEC_SIZE_IN_BYTS];
	
	DxUint8_t					TST_Key[TST_HMAC_MAX_KEY_SIZE];
	DxUint16_t                  TST_KeySize;
	DxUint16_t                  TST_Expected_dataSize;	
	
	CRYS_HASH_OperationMode_t	TST_OperationMode;
} TST_HMACFLOW_TestDataStruct;


/************************ Public Variables **********************/
/************************ Public Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HMACSTATIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static HMAC FLOW API's
 
 * Algorithm:     
 *	This function initializes HMAC flow with static type and other parameters,
 *  sends interrupts that input and output buffers are ready, finishes HMAC flow, 
 *  reads data from the output buffers and compare to expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HMACSTATIC_Acceptance ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HMACDYNAMIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static HMAC FLOW API's
 
 * Algorithm:     
 *	This function goes through all tests vectors and execute HMAC dynamic flow acceptance test
 *  for each vector
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HMACDYNAMIC_Acceptance ( void );


/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_HMACDYNAMIC_AddBuffers_Acceptance
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for dynamic HMAC FLOW API's

* Algorithm:     
*	This function initializes HNAC flow with dynamic type and other parameters,
*  sends interrupts that input and output buffers are ready, adds buffers to
*  dynamic flow, finishes HMAC flow, 
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HMACDYNAMIC_AddBuffers_Acceptance ( void );


/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_HMACSTATIC_Acceptance_WithAdditionalEngines
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for static HMAC FLOW API's with additional engines.

* Algorithm:     
*  This function goes through all flow vectors and execute acceptance test with 
*  additional engines for each vector
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HMACSTATIC_Acceptance_WithAdditionalEngines ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_HMACDYNAMIC_Acceptance_WithAdditionalEngines
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for static HMAC FLOW API's with additional engines.

* Algorithm:     
*  This function goes through all flow vectors and execute acceptance test with 
*  additional engines for each vector
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HMACDYNAMIC_Acceptance_WithAdditionalEngines ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HMACSTATIC_Cyclic_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static cyclic HMAC FLOW API's
 
 * Algorithm:     
 *	This function initializes HMAC flow with static type and other parameters,
 * and executes several times flow on the same input buffer. It goes throw all test
 * vectors and check cyclic acceptance.
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HMACSTATIC_Cyclic_Acceptance ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HMAC_ONETEST_Acceptance
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_MasterTestName - test name
 *  flowType           - flow type (static or dynamic)
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static HMAC FLOW API's
 
 * Algorithm:     
 *  1. Initialize HMAC flow with type and other parameters
 *  2. Send interrupts that input and output buffers are ready
 *  3. Finish HMAC flow and compare output to expected results
 *  4. Terminate flow
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HMAC_ONETEST_Acceptance ( int             TST_index, 
                                                        char            *TST_MasterTestName,
                                                        CRYS_FLOW_Type_t flowType );
                                                        
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HMACSTATIC_ONETEST_Cyclic_Acceptance
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_MasterTestName - test name 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static cyclic HMAC FLOW API's
 
 * Algorithm:     
 * 1. Initialize HMAC flow with static type and other parameters 
 * 2. Init HMAC flow
 * 3. Send interrupts to execute cyclic flow operation 
 * 4. Finish HMAC flow
 * 5. Get results
 * 6. Terminate flow
 * 7. Read data from the output buffers and compare to expected result
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HMACSTATIC_ONETEST_Cyclic_Acceptance ( int   TST_index,
                                                                     char *TST_MasterTestName ); 
                                                        


/************************ Private Functions **********************/


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_InitHMACFlow
 *  
 * Inputs:
 *  TST_index          - test index
 *  flowType           - flow type
 *  TST_MasterTestName - test name
 *  TST_HMACFlowId      - output HMAC flow id
 *  pHMACFlowParamsInfo - flow params info
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function starts HMAC flow.
 *
 * Algorithm:     
 *	This function inits HMAC flow.
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_InitHMACFlow ( int                     TST_index,
                                        CRYS_FLOW_Type_t        flowType,
                                        char                   *TST_MasterTestName, 
                                        DxUint32_t             *TST_HMACFlowId,
                                        CRYS_FLOW_Params_t     *pHMACFlowParamsInfo );
                                        
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FinishHMACFlow
 *  
 * Inputs:
 *  TST_index           - test index
 *  TST_HMAC            - flow id
 *  TST_MasterTestName  - test name
 *  blockSize           - block size for finish
 *  pHMACFlowParamsInfo - flow params info
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function finishes HMAC flow and check results.
 *
 * Algorithm:     
 *	1. Finish HMAC flow
 *  2. Get results
 *  3. Compare output buffer with expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FinishHMACFlow ( int                     TST_index, 
                                          DxUint32_t              TST_HMACFlowId, 
                                          char                   *TST_MasterTestName,
                                          DxUint32_t              blockSize,
                                          CRYS_FLOW_Params_t     *pHMACFlowParamsInfo );
                                        





#ifdef __cplusplus
}
#endif

#endif

#endif
